IF OBJECT_ID('P_EXP_CTB_MOV_RC_CRED') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_MOV_RC_CRED;
    END;
GO 
 

CREATE PROCEDURE P_EXP_CTB_MOV_RC_CRED(@CD_EMP      INT,
                                       @CD_FILIAL   INT,
                                       @DT_INI      DATETIME,
                                       @DT_FIM      DATETIME,
                                       @FLAG_LIMPAR INT      = 0)
WITH ENCRYPTION
AS
SET NOCOUNT ON;
    BEGIN TRY
        BEGIN
            DECLARE @RS_CD_EMP INT;
            DECLARE @RS_CD_FILIAL INT;
            DECLARE @RS_VL_PGTO MONEY;
            DECLARE @RS_VL_JUR MONEY;
            DECLARE @RS_VL_DESC MONEY;
            DECLARE @RS_VLR_GLOSA MONEY;
            DECLARE @RS_CD_CNT INT;
            DECLARE @RS_CD_CLI INT;
            DECLARE @RS_RZ_CLI VARCHAR(200);
            DECLARE @RS_HIST_LANCTO VARCHAR(150);
            DECLARE @RS_NR_DP INT;
            DECLARE @RS_ANO INT;
            DECLARE @RS_PARC INT;
            DECLARE @RS_CD_RC_DEB INT;
            DECLARE @RS_NM_FANT VARCHAR(100);
            DECLARE @RS_DUP_PROV_RECU_GLOSA INT;
            DECLARE @RS_TP_TRANSACAO INT;
            DECLARE @RS_DT_PAG DATETIME;
            DECLARE @CD_CTB_CNT_CARTAO INT;
            DECLARE @CD_CTB_CNT_CARTAO_RED INT;
            DECLARE @RET_CD_CTB_CNT VARCHAR(100);
            DECLARE @RET_CD_CTB_CNT_RED INT;
            DECLARE @RET_DS_CNT VARCHAR(100);
            DECLARE @RET_NR_CNT VARCHAR(50);
            DECLARE @RET_TP_CNT INT;
            DECLARE @RET_TITULAR_CNT VARCHAR(200);
            DECLARE @RET_RZ_CLI VARCHAR(200);
            DECLARE @HIST VARCHAR(200);
            DECLARE @CLI_CONV INT;
		  DECLARE @RS_VLR_IMPOSTO MONEY;
		  DECLARE @NUM_DUPL                       BIGINT 
		  DECLARE @NUMERODUPL                     VARCHAR(20)
		  DECLARE @COUNT_EXP_CONTABIL INT = 1

            ------------------------------------------------------------------------------------------------------------------------------
            --CRIANDO A TABELA TEMPORARIA ##CTB_EXP_MOV
            ------------------------------------------------------------------------------------------------------------------------------
            EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV
                 @FLAG_LIMPAR;
            DECLARE RS_RESULT CURSOR
            FOR SELECT CD_EMP
                     , CD_FILIAL
                     , VL_PGTO
                     , VL_JUR
                     , VL_DESC
                     , VLR_GLOSA
                     , CD_CNT
                     , CD_CLI
                     , RZ_CLI
                     , HIST_LANCTO
                     , NR_DP
                     , ANO
                     , PARC
                     , CD_RC_DEB
                     , NM_FANT
                     , DUP_PROV_RECU_GLOSA
                     , TP_TRANSACAO
                     , DT_PAG
                     , CD_CTB_CNT_CARTAO
                     , CD_CTB_CNT_CARTAO_RED
				 , VLR_IMPOSTO
                FROM UFD_EXP_CTB_MOV_RC_CRED(@CD_EMP, @CD_FILIAL, @DT_INI, @DT_FIM)
                ORDER BY CD_EMP
                       , CD_FILIAL
                       , DT_PAG;
		 

            --Abrindo cursor
            OPEN RS_RESULT;
		
            --Atribuindo valores do select nas variveis
            FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_VL_PGTO, @RS_VL_JUR, 
										   @RS_VL_DESC, @RS_VLR_GLOSA, @RS_CD_CNT, @RS_CD_CLI, 
										   @RS_RZ_CLI, @RS_HIST_LANCTO, @RS_NR_DP, @RS_ANO, 
										   @RS_PARC, @RS_CD_RC_DEB, @RS_NM_FANT, @RS_DUP_PROV_RECU_GLOSA, 
										   @RS_TP_TRANSACAO, @RS_DT_PAG, @CD_CTB_CNT_CARTAO, 
										   @CD_CTB_CNT_CARTAO_RED,@RS_VLR_IMPOSTO;								
					 

            --Iniciando lao
            WHILE @@FETCH_STATUS = 0
                BEGIN				
				
				SET @NUMERODUPL =  RIGHT('0000'+ CAST(@RS_CD_FILIAL AS VARCHAR(4)),4) + CAST(@RS_NR_DP AS VARCHAR )
				SET @NUM_DUPL  =  @NUMERODUPL 
                    ------------------------------------------------------------------------------------------------------------------
                    --RECEBIMENTO DE DUPLICATAS - DEBITO - CLIENTES
                    ------------------------------------------------------------------------------------------------------------------
                    IF @RS_VL_PGTO > 0
                        BEGIN
                            SELECT @RET_CD_CTB_CNT = CD_CTB_CNT
                                 , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                 , @RET_DS_CNT = DS_CNT
                                 , @RET_NR_CNT = NR_CNT
                                 , @RET_TP_CNT = TP_CNT
                                 , @RET_TITULAR_CNT = TITULAR_CNT
                            FROM UFD_BUSCA_CONTA_BC_CONTAS(@CD_EMP, @RS_CD_CNT);
                            IF @RS_TP_TRANSACAO = 0
                                BEGIN
                                    IF EXISTS
                                    (
                                        SELECT T.CD_EMP
                                        FROM RC_CLI_CONV_GLOSA_RC_DEB T
                                        WHERE T.CD_EMP = @RS_CD_EMP
                                              AND T.CD_FILIAL = @RS_CD_FILIAL
                                              AND T.NR_DP = @RS_NR_DP
                                              AND T.ANO = @RS_ANO
                                    )
                                        BEGIN
                                            SET @HIST = 'GLOSA RECUPERADA EM NEGOCIAO COM O CONVNIO: '+@RS_RZ_CLI+' - REF: '+@RS_HIST_LANCTO+' CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                            INSERT INTO ##CTB_EXP_MOV

											 (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
											 CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
											 VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
											 ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                                   SELECT @RS_CD_EMP AS CD_EMP
                                                        , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                        , @RS_CD_FILIAL AS CD_FILIAL
                                                        , 17 AS CD_MOVIMENTO
                                                        , 'RECUPERACAO DE GLOSA' AS MOVIMENTO
                                                        , '' AS OPERACAO
                                                        , 'RECUPERACAO DE GLOSA - DEBITO' AS OPERACAO_DEBITO
                                                        , 0 AS CD_CNT_RED_CREDITO
                                                        , '' AS CD_CNT_CREDITO
                                                        , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                        , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                        , @RS_DT_PAG AS DT_MOV
                                                        , @HIST AS HIST
                                                        , (@RS_VL_PGTO + @RS_VL_JUR) - (@RS_VL_DESC + @RS_VLR_IMPOSTO ) AS VLR_LANC
                                                        , 'D' AS TP_TRANSA
                                                        , 0 AS RATEIO_CENTRO_CUSTO
                                                        , '' AS DS_CENTRO_CUSTO
                                                        , 0 AS CNT_CENTRO_CUSTO
                                                        , 0 AS VLR_CENTRO_CUSTO
                                                        , 'CNT BANC' AS ORIG_CONTA
                                                        , @RS_CD_CNT AS COD_CONTA
                                                        , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                        , 'X' AS TIPO_LANCTO
                                                        , 0 AS CD_EVENTO
											 , @NUM_DUPL  AS NR_DP
											 , @RS_ANO  AS ANO
											 , '' AS NR_DOC
											 , @COUNT_EXP_CONTABIL AS CD_BC_LANC;
                                        END;
                                    ELSE
                                        BEGIN
                                            SET @HIST = 'REF: '+@RS_HIST_LANCTO+' CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                            INSERT INTO ##CTB_EXP_MOV

										  (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
										  CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
										  VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
										  ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                                   SELECT @RS_CD_EMP AS CD_EMP
                                                        , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                        , @RS_CD_FILIAL AS CD_FILIAL
                                                        , 18 AS CD_MOVIMENTO
                                                        , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                        , '' AS OPERACAO
                                                        , 'RECEBIMENTO DUPLICATA - DEBITO' AS OPERACAO_DEBITO
                                                        , 0 AS CD_CNT_RED_CREDITO
                                                        , '' AS CD_CNT_CREDITO
                                                        , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                        , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                        , @RS_DT_PAG AS DT_MOV
                                                        , @HIST AS HIST
                                                        , (@RS_VL_PGTO + @RS_VL_JUR) - (@RS_VL_DESC + @RS_VLR_GLOSA + @RS_VLR_IMPOSTO) AS VLR_LANC
                                                        , 'D' AS TP_TRANSA
                                                        , 0 AS RATEIO_CENTRO_CUSTO
                                                        , '' AS DS_CENTRO_CUSTO
                                                        , 0 AS CNT_CENTRO_CUSTO
                                                        , 0 AS VLR_CENTRO_CUSTO
                                                        , 'CLIENTES' AS ORIG_CONTA
                                                        , @RS_CD_CLI AS COD_CONTA
                                                        , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                        , 'X' AS TIPO_LANCTO
                                                        , 0 AS CD_EVENTO
											 , @NUM_DUPL  AS NR_DP
											 , @RS_ANO  AS ANO
											 , '' AS NR_DOC
											 , @COUNT_EXP_CONTABIL AS CD_BC_LANC;
                                        END;
                                END;
                            ------------------------------------------------------------------------------------------------------------------
                            --RECEBIMENTO DE DUPLICATAS - DEBITO - CLIENTES / 
                            ------------------------------------------------------------------------------------------------------------------
                            IF @RS_TP_TRANSACAO = 1
                                BEGIN
										IF LEFT( @RS_HIST_LANCTO, 11) = 'ANTECIPAO'
											BEGIN
											   SET @HIST = 'REF: '+@RS_HIST_LANCTO ;
											   END
										ELSE
											   BEGIN
												SET @HIST = 'REF: '+@RS_HIST_LANCTO +' PGTO: CARTO DEBITO\CREDITO';  --+ ' CONTA: ' + ISNULL(@RET_DS_CNT,'') + ' - ' + ISNULL(@RET_NR_CNT,''
										   END
                                    INSERT INTO ##CTB_EXP_MOV

									   (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP 				      AS CD_EMP
                                                , @CD_FILIAL 			          AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL 			      AS CD_FILIAL
                                                , 18 							  AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , ''                              AS OPERACAO
                                                , 'RECEBIMENTO DUPLICATA - DEBITO'     AS OPERACAO_DEBITO
                                                , 0                               AS CD_CNT_RED_CREDITO
                                                , ''                              AS CD_CNT_CREDITO
                                                , @CD_CTB_CNT_CARTAO_RED          AS CD_CNT_RED_DEBITO
                                                , @CD_CTB_CNT_CARTAO              AS CD_CNT_DEBITO
                                                , @RS_DT_PAG  					  AS DT_MOV
                                                , @HIST	           				  AS HIST
                                                , (@RS_VL_PGTO + @RS_VL_JUR) - (@RS_VL_DESC + @RS_VLR_GLOSA + @RS_VLR_IMPOSTO) AS VLR_LANC
                                                , 'D' 							  AS TP_TRANSA
                                                , 0 							  AS RATEIO_CENTRO_CUSTO
                                                , ''							  AS DS_CENTRO_CUSTO
                                                , 0 							  AS CNT_CENTRO_CUSTO
                                                , 0 							  AS VLR_CENTRO_CUSTO
                                                , 'FILIAIS'						  AS ORIG_CONTA
                                                , 0        						  AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) 		  AS NM_PROCEDURE
                                                , 'X'                             AS TIPO_LANCTO
                                                , 0                               AS CD_EVENTO
												, @NUM_DUPL                       AS NR_DP
												, @RS_ANO                         AS ANO
												, ''						      AS NR_DOC
												, @COUNT_EXP_CONTABIL 							  AS CD_BC_LANC;
                                END;
                            ------------------------------------------------------------------------------------------------------------------
                            --RECEBIMENTO DE DUPLICATAS - CREDITO - CLIENTES / Ctb_Cnt_Glosas_Convenio
                            ------------------------------------------------------------------------------------------------------------------				
                            IF @RS_TP_TRANSACAO = 0
                               OR @RS_CD_CNT <> 0
                                BEGIN
                                    SET @HIST = 'REF: '+@RS_HIST_LANCTO+' CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                END;
                            ELSE
                                BEGIN
                                    SET @HIST = 'REF: '+@RS_HIST_LANCTO+' PGTO: CARTO DEBITO\CREDITO';
                                END;
                            IF @RS_DUP_PROV_RECU_GLOSA = 0
                                BEGIN
                                    SELECT @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_RZ_CLI = RZ_CLI
                                    FROM UFD_BUSCA_CONTA_RC_CLI(@RS_CD_EMP, @RS_CD_CLI, 0);
                                END;
                            INSERT INTO ##CTB_EXP_MOV

					   			(CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                   SELECT @RS_CD_EMP AS CD_EMP
                                        , @CD_FILIAL AS CD_FILIAL_EXPORT
                                        , @RS_CD_FILIAL AS CD_FILIAL
                                        , 18 AS CD_MOVIMENTO
                                        , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                        , 'RECEBIMENTO DUPLICATA - CREDITO' AS OPERACAO
                                        , '' AS OPERACAO_DEBITO
                                        , (CASE
                                               WHEN @RS_DUP_PROV_RECU_GLOSA = 0
                                               THEN @RET_CD_CTB_CNT_RED
                                               ELSE 0
                                           END) AS CD_CNT_RED_CREDITO
                                        , (CASE
                                               WHEN @RS_DUP_PROV_RECU_GLOSA = 0
                                               THEN @RET_CD_CTB_CNT
                                               ELSE ''
                                           END) AS CD_CNT_CREDITO
                                        , 0 AS CD_CNT_RED_DEBITO
                                        , '' AS CD_CNT_DEBITO
                                        , @RS_DT_PAG AS DT_MOV
                                        , @HIST AS HIST
                                        , @RS_VL_PGTO - (@RS_VL_DESC + @RS_VLR_GLOSA + @RS_VLR_IMPOSTO) AS VLR_LANC
                                        , 'C' AS TP_TRANSA
                                        , 0 AS RATEIO_CENTRO_CUSTO
                                        , '' AS DS_CENTRO_CUSTO
                                        , 0 AS CNT_CENTRO_CUSTO
                                        , 0 AS VLR_CENTRO_CUSTO
                                        , (CASE
                                               WHEN @RS_DUP_PROV_RECU_GLOSA = 0
                                               THEN 'CLIENTES'
                                               ELSE 'FILIAIS'
                                           END) AS ORIG_CONTA
                                        , (CASE
                                               WHEN @RS_DUP_PROV_RECU_GLOSA = 0
                                               THEN @RS_CD_CLI
                                               ELSE 23
                                           END) AS COD_CONTA
                                        , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                        , 'X' AS TIPO_LANCTO
                                        , 0 AS CD_EVENTO
								, @NUM_DUPL  AS NR_DP
								, @RS_ANO  AS ANO
								, '' AS NR_DOC
								, @COUNT_EXP_CONTABIL AS CD_BC_LANC;	
														
                            ------------------------------------------------------------------------------------------------------------------
                            --DESCONTOS CONCEDIDOS   
                            ------------------------------------------------------------------------------------------------------------------				
                            IF @RS_VL_DESC > 0 OR  @RS_VLR_IMPOSTO >  0 
                                BEGIN
                                    ------------------------------------------------------------------------------------------------------------------
                                    --DESCONTOS CONCEDIDOS  - DEBITO - Ctb_Cnt_Descontos_Concedidos
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                         , @RET_DS_CNT = DS_CNT
                                         , @RET_NR_CNT = NR_CNT
                                         , @RET_TP_CNT = TP_CNT
                                         , @RET_TITULAR_CNT = TITULAR_CNT
                                    FROM UFD_BUSCA_CONTA_BC_CONTAS(@CD_EMP, @RS_CD_CNT);
                                    IF @RS_TP_TRANSACAO = 0
                                        BEGIN
                                            SET @HIST = 'DESCONTO CONCEDIDO: '+@RS_HIST_LANCTO+' - REF: '+CAST(@RS_NR_DP AS VARCHAR)+'/'+CAST(@RS_ANO AS VARCHAR)+' Parc: '+CAST(@RS_PARC AS VARCHAR)+' CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                        END;
                                    ELSE
                                        BEGIN
                                            SET @HIST = 'DESCONTO CONCEDIDO: '+@RS_HIST_LANCTO+' - REF: '+CAST(@RS_NR_DP AS VARCHAR)+'/'+CAST(@RS_ANO AS VARCHAR)+' Parc: '+CAST(@RS_PARC AS VARCHAR)+' PAGTO: CARTO DEBITO\CREDITO';
                                        END;
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 18 AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'DESCONTOS CONCEDIDOS - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_PAG AS DT_MOV
                                                , @HIST AS HIST
                                                , (@RS_VL_DESC + @RS_VLR_IMPOSTO ) AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , 0 AS RATEIO_CENTRO_CUSTO
                                                , '' AS DS_CENTRO_CUSTO
                                                , 0 AS CNT_CENTRO_CUSTO
                                                , 0 AS VLR_CENTRO_CUSTO
                                                , 'FILIAIS' AS ORIG_CONTA
                                                , 21 AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , 'X' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , @NUM_DUPL  AS NR_DP
								        , @RS_ANO  AS ANO
									   , '' AS NR_DOC
									   , @COUNT_EXP_CONTABIL AS CD_BC_LANC;														
														
								
                                    ------------------------------------------------------------------------------------------------------------------
                                    --DESCONTOS CONCEDIDOS  - CREDITO - CLIENTES
                                    ------------------------------------------------------------------------------------------------------------------
                                    SELECT @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_RZ_CLI = RZ_CLI
                                    FROM UFD_BUSCA_CONTA_RC_CLI(@RS_CD_EMP, @RS_CD_CLI, 0);

                                    INSERT INTO ##CTB_EXP_MOV

									   (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
									   CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
									   VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
									   ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 18 AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , 'DESCONTOS CONCEDIDOS - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
												, @RET_CD_CTB_CNT_RED AS CD_CNT_RED_CREDITO
												, @RET_CD_CTB_CNT  AS CD_CNT_CREDITO
												, 0 AS CD_CNT_RED_DEBITO
												, '' as CD_CNT_DEBITO
                                                , @RS_DT_PAG AS DT_MOV
                                                , @HIST AS HIST
                                                ,( @RS_VL_DESC + @RS_VLR_IMPOSTO )AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , 0 AS RATEIO_CENTRO_CUSTO
                                                , '' AS DS_CENTRO_CUSTO
                                                , 0 AS CNT_CENTRO_CUSTO
                                                , 0 AS VLR_CENTRO_CUSTO
                                                , 'CLIENTES' AS ORIG_CONTA
                                                , @RS_CD_CLI AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , 'X' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , @NUM_DUPL  AS NR_DP
									   , @RS_ANO  AS ANO
							             , '' AS NR_DOC
									   , @COUNT_EXP_CONTABIL AS CD_BC_LANC;
                                END;
						
                            ------------------------------------------------------------------------------------------------------------------
                            --JUROS  - CREDITO - Ctb_Cnt_Juros_Duplicata_Recebida_Atraso
                            ------------------------------------------------------------------------------------------------------------------
                            IF @RS_VL_JUR > 0
                                BEGIN
                                    SELECT @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                         , @RET_DS_CNT = DS_CNT
                                         , @RET_NR_CNT = NR_CNT
                                         , @RET_TP_CNT = TP_CNT
                                         , @RET_TITULAR_CNT = TITULAR_CNT
                                    FROM UFD_BUSCA_CONTA_BC_CONTAS(@CD_EMP, @RS_CD_CNT);
                                    IF @RS_TP_TRANSACAO = 0
                                        BEGIN
                                            SET @HIST = 'JUROS S/ DUPL. RECEB: '+@RS_HIST_LANCTO+' - REF: '+CAST(@RS_NR_DP AS VARCHAR)+'/'+CAST(@RS_ANO AS VARCHAR)+' Parc: '+CAST(@RS_PARC AS VARCHAR)+' CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                        END;
                                    ELSE
                                        BEGIN
                                            SET @HIST = 'JUROS S/ DUPL. RECEB: '+@RS_HIST_LANCTO+' - REF: '+CAST(@RS_NR_DP AS VARCHAR)+'/'+CAST(@RS_ANO AS VARCHAR)+' Parc: '+CAST(@RS_PARC AS VARCHAR)+' PAGTO: CARTO DEBITO\CREDITO';
                                        END;
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 18 AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , 'JUROS S/ DUPL. RECEBIDA - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_PAG AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VL_JUR AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , 0 AS RATEIO_CENTRO_CUSTO
                                                , '' AS DS_CENTRO_CUSTO
                                                , 0 AS CNT_CENTRO_CUSTO
                                                , 0 AS VLR_CENTRO_CUSTO
                                                , 'FILIAIS' AS ORIG_CONTA
                                                , 24 AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , 'X' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , @NUM_DUPL  AS NR_DP
									   , @RS_ANO  AS ANO
									   , '' AS NR_DOC
									   , @COUNT_EXP_CONTABIL AS CD_BC_LANC;
                                END;
						
                            ------------------------------------------------------------------------------------------------------------------
                            --GLOSA 
                            ------------------------------------------------------------------------------------------------------------------
                            IF @RS_VLR_GLOSA > 0
                                BEGIN
                                    ------------------------------------------------------------------------------------------------------------------
                                    --GLOSA  - CREDITO - Ctb_Cnt_Glosas_Convenio / Ctb_Cnt_Glosas
                                    ------------------------------------------------------------------------------------------------------------------

                                    SET @CLI_CONV = ISNULL(
                                                          (
                                                              SELECT T.CD_EMP
                                                              FROM RC_CLI_CONV_VINC_RC_CLI T
                                                              WHERE T.CD_EMP = @RS_CD_EMP
                                                                    AND T.CD_CLI = @RS_CD_CLI
                                                          ), 0);
                                    IF @RS_TP_TRANSACAO = 0
                                        BEGIN
                                            SET @HIST = 'PAGTO. DE GLOSA A RECUPERAR S/ CONVNIO: '+@RS_RZ_CLI+' - CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                        END;
                                    ELSE
                                        BEGIN
                                            SET @HIST = 'PAGO GLOSA NO RECBTO. DA DUPLICATA N: '+CAST(@RS_NR_DP AS VARCHAR)+'/'+CAST(@RS_ANO AS VARCHAR)+' Parc: '+CAST(@RS_PARC AS VARCHAR)+' Cliente: '+@RS_RZ_CLI+' - CONTA: '+ISNULL(@RET_DS_CNT, '')+' - '+ISNULL(@RET_NR_CNT, '');
                                        END;
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)


                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 18 AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , 'PAGTO GLOSA - CREDITO' AS OPERACAO
                                                , '' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , 0 AS CD_CNT_RED_DEBITO
                                                , '' AS CD_CNT_DEBITO
                                                , @RS_DT_PAG AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_GLOSA AS VLR_LANC
                                                , 'C' AS TP_TRANSA
                                                , 0 AS RATEIO_CENTRO_CUSTO
                                                , '' AS DS_CENTRO_CUSTO
                                                , 0 AS CNT_CENTRO_CUSTO
                                                , 0 AS VLR_CENTRO_CUSTO
                                                , 'FILIAIS' AS ORIG_CONTA
                                                , (CASE
                                                       WHEN @CLI_CONV > 0
                                                       THEN 23
                                                       ELSE 22
                                                   END) AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , 'X' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , @NUM_DUPL  AS NR_DP
									   , @RS_ANO  AS ANO
									   , '' AS NR_DOC
									   , @COUNT_EXP_CONTABIL AS CD_BC_LANC;								
                                    ------------------------------------------------------------------------------------------------------------------
                                    --GLOSA  - DEBITO - CLIENTES
                                    ------------------------------------------------------------------------------------------------------------------

                                    SELECT @RET_CD_CTB_CNT_RED = CD_CTB_CNT_RED
                                         , @RET_CD_CTB_CNT = CD_CTB_CNT
                                         , @RET_RZ_CLI = RZ_CLI
                                    FROM UFD_BUSCA_CONTA_RC_CLI(@RS_CD_EMP, @RS_CD_CLI, 0);
                                    INSERT INTO ##CTB_EXP_MOV

								    (CD_EMP,  CD_FILIAL_EXPORT,CD_FILIAL, CD_MOVIMENTO, MOVIMENTO, OPERACAO, OPERACAO_DEBITO,
								    CD_CNT_RED_CREDITO, CD_CNT_CREDITO, CD_CNT_RED_DEBITO, CD_CNT_DEBITO, DT_MOV, HIST,
								    VLR_LANC, TP_TRANSA, RATEIO_CENTRO_CUSTO, DS_CENTRO_CUSTO, CNT_CENTRO_CUSTO, VLR_CENTRO_CUSTO,
								    ORIG_CONTA, COD_CONTA,NM_PROCEDURE,TIPO_LANCTO, CD_EVENTO, NR_DP, ANO, NR_DOC, CD_BC_LANC)

                                           SELECT @RS_CD_EMP AS CD_EMP
                                                , @CD_FILIAL AS CD_FILIAL_EXPORT
                                                , @RS_CD_FILIAL AS CD_FILIAL
                                                , 18 AS CD_MOVIMENTO
                                                , 'RECEBIMENTO DUPLICATA CLIENTE' AS MOVIMENTO
                                                , '' AS OPERACAO
                                                , 'PAGTO GLOSA - DEBITO' AS OPERACAO_DEBITO
                                                , 0 AS CD_CNT_RED_CREDITO
                                                , '' AS CD_CNT_CREDITO
                                                , @RET_CD_CTB_CNT_RED AS CD_CNT_RED_DEBITO
                                                , @RET_CD_CTB_CNT AS CD_CNT_DEBITO
                                                , @RS_DT_PAG AS DT_MOV
                                                , @HIST AS HIST
                                                , @RS_VLR_GLOSA AS VLR_LANC
                                                , 'D' AS TP_TRANSA
                                                , 0 AS RATEIO_CENTRO_CUSTO
                                                , '' AS DS_CENTRO_CUSTO
                                                , 0 AS CNT_CENTRO_CUSTO
                                                , 0 AS VLR_CENTRO_CUSTO
                                                , 'CLIENTES' AS ORIG_CONTA
                                                , @RS_CD_CLI AS COD_CONTA
                                                , OBJECT_NAME(@@PROCID) AS NM_PROCEDURE
                                                , 'X' AS TIPO_LANCTO
                                                , 0 AS CD_EVENTO
									   , @NUM_DUPL  AS NR_DP
									   , @RS_ANO  AS ANO
									   , '' AS NR_DOC
									   , @COUNT_EXP_CONTABIL AS CD_BC_LANC;
                                END;
                        END;

						SET @COUNT_EXP_CONTABIL = @COUNT_EXP_CONTABIL + 1;

					--SELECT * FROM ##CTB_EXP_MOV
                    ------------------------------------------------------------------------------------------------------------------
                    --Prximo registro				
                    ------------------------------------------------------------------------------------------------------------------
                    --Atribuindo valores do select nas variveis
                    FETCH NEXT FROM RS_RESULT INTO @RS_CD_EMP, @RS_CD_FILIAL, @RS_VL_PGTO, @RS_VL_JUR, 
												   @RS_VL_DESC, @RS_VLR_GLOSA, @RS_CD_CNT, @RS_CD_CLI, 
												   @RS_RZ_CLI, @RS_HIST_LANCTO, @RS_NR_DP, @RS_ANO, 
												   @RS_PARC, @RS_CD_RC_DEB, @RS_NM_FANT, 
												   @RS_DUP_PROV_RECU_GLOSA, @RS_TP_TRANSACAO, @RS_DT_PAG, 
												   @CD_CTB_CNT_CARTAO, @CD_CTB_CNT_CARTAO_RED, @RS_VLR_IMPOSTO;

												   
                END;
            CLOSE RS_RESULT;
            DEALLOCATE RS_RESULT;
        END;
    END TRY
    BEGIN CATCH
        CLOSE RS_RESULT;
        DEALLOCATE RS_RESULT;
        INSERT INTO ADM_ERRO
        (numero
       , severidade
       , estado
       , rotina
       , linha
       , mensagem
       , dtErro
        )
               SELECT ERROR_NUMBER() AS numero
                    , ERROR_SEVERITY() AS severidade
                    , ERROR_STATE() AS estado
                    , ERROR_PROCEDURE() AS rotina
                    , ERROR_LINE() AS linha
                    , ERROR_MESSAGE() AS mensagem
                    , GETDATE() AS dtErro;
    END CATCH;